<?php
/*======================================================================*\
|| #################################################################### ||
|| # SHQAWE POSTS ALERTS CLEAN UP JOB
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2025-2026 SHQAWE@GMAIL.COM , Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # Visit https://www.shqawe.net for more products and styles        # ||
|| #################################################################### ||
\*======================================================================*/


error_reporting(E_ALL & ~E_NOTICE);
if (!is_object($vbulletin->db)) {
    exit;
}

$spaCronDay = 7; // default value

if (
    isset($vbulletin->options['spa_cron_days'])
    && $vbulletin->options['spa_cron_days'] != ''
    && is_numeric($vbulletin->options['spa_cron_days'])
) {
    $spaCronDay = intval($vbulletin->options['spa_cron_days']);

    // Ensure it's a positive number
    if ($spaCronDay <= 0) {
        $spaCronDay = 7;
    }
}

// Calculate the cutoff date (SUBTRACT from current time to get past date)
$deleteDate = time() - ((60 * 60 * 24) * $spaCronDay);

// Only run if the feature is enabled
if ($vbulletin->options['spa_act']) {
    // Delete records older than the cutoff date
    $vbulletin->db->query_write(
        "
        DELETE FROM " . TABLE_PREFIX . "shqawe_posts_alert 
        WHERE spa_date < " . intval($deleteDate)
    );

    // Optional: Log how many records were deleted
    $affected_rows = $vbulletin->db->affected_rows();
    log_cron_action("Deleted {$affected_rows} old post alerts (older than {$spaCronDay} days)", $nextitem, 1);
}
