<?php
$otherfetch = array();
$usernames = array();
do
{
	if ($this->registry->options['dbtech_usertag_disabledfeatures'] & 1)
	{
		// Mentions are disabled
		break;
	}

	if (!$matches = USERTAG::match(strip_quotes($message), 'at' . ($this->registry->options['dbtech_usertag_requiresemicolon'] ? '_legacy' : '')))
	{
		// No matches found
		break;
	}

	$usergroups = array();
	foreach ($this->registry->usergroupcache as $usergroupid => $usergroup)
	{
		$usergroups[strtolower($usergroup['title'])] = $usergroupid;
	}
	
	foreach ($matches as $username)
	{
		$username = trim($username);
		
		
		// Just the one
		$usernames[] = htmlspecialchars_uni($username);
	}

	if (!empty($usernames) AND !count($otherfetch))
	{
		// Weed out duplicates
		$usernames = array_unique($usernames);
		
		// Fetch users who haven't been tagged before
		$users = USERTAG::$db->fetchAll('
			SELECT
				user.userid,
				username,
				usergroupid,
				membergroupids,
				displaygroupid,
				infractiongroupids,
				user.dbtech_usertag_excluded AS excluded,
				relationid,
				userlist.type,
				friend,
				dbtech_usertag_settings,
				email,
				languageid,
				options,
				adminoptions
				:dateline
			FROM $user AS user
			LEFT JOIN $userlist AS userlist ON (userlist.userid = user.userid AND userlist.relationid = ?)				
			' . ($info['postid'] ? 'LEFT JOIN $dbtech_usertag_mention AS mention ON(mention.mentionedid = user.userid AND mention.postid = ? AND mention.type = ?)' : '') . '
			WHERE username :queryList
		', array(
			':dateline' => ($info['postid'] ? ', mention.dateline' : ', NULL AS dateline'),
			':queryList' => USERTAG::$db->queryList($usernames),
			$this->registry->userinfo['userid'],
			$info['postid'],
			$info['type']
		));

		$usernames = array();
		foreach ($users as $results_r)
		{
			$results_r = array_merge($results_r, convert_bits_to_array($results_r['options'], 		$this->registry->bf_misc_useroptions));
			$results_r = array_merge($results_r, convert_bits_to_array($results_r['adminoptions'], 	$this->registry->bf_misc_adminoptions));
			
			// Grab our usergroup permissions
			cache_permissions($results_r);
			
			// Store this
			$username = unhtmlspecialchars($results_r['username']);
			
			if (empty($username))
			{
				// For some reason this might be relevant O.o
				continue;
			}
			
			// Store this
			$usernames[strtolower($username)] = $results_r;
		}
		
		// Reverse sorting for better matching
		krsort($usernames, SORT_STRING);
		
		$i = 0;
		foreach ($usernames as $results_r)
		{
			// Replace post content
			$possible = array(
				'/\[mention=?\d*\]' . preg_quote(unhtmlspecialchars($results_r['username']), '/') . '\[\/mention\]/iU',
				'/^@' . preg_quote(unhtmlspecialchars($results_r['username']), '/') . ';?:?/iU',
				'/[^0-9A-Za-z]@' . preg_quote(unhtmlspecialchars($results_r['username']), '/') . ';?:?/iU'
			);
			$message = preg_replace($possible, ' [MENTION=' . $results_r['userid'] . ']' . unhtmlspecialchars($results_r['username']) . '[/MENTION]', $message, -1, $found);

			if (($results_r['permissions']['dbtech_usertagpermissions'] & $this->registry->bf_ugp_dbtech_usertagpermissions['isexcluded']) OR
				($info['postid'] AND $results_r['dateline'] !== NULL) OR
				($results_r['excluded']) OR
				($results_r['userid'] == ($this->existing['userid'] ? $this->existing['userid'] : $this->registry->userinfo['userid']))
			)
			{
				// Excluded guy
				continue;
			}
			
			if (($results_r['dbtech_usertag_settings'] & 1) AND ($results_r['type'] != 'buddy' OR $results_r['friend'] != 'yes'))
			{
				// Can't mention this user
				continue;
			}
			
			// Add to globals
			if ($found)
			{
				$info['mention'][$results_r['userid']] = $results_r;

				if (++$i == $this->registry->options['dbtech_usertag_mentions_per_post'])
				{
					// This will never trigger when mentions per post is 0
					break;
				}
			}
		}
	}
	
	
}
while (false);
?>